$(document).ready(function () {


    const client = supabase.createClient(
      'https://yoururl.supabase.co', // Replace with your Supabase URL
      'your-api-key'                        // Replace with your Supabase anon key
    );

    const router = new Router('/run-framework/03-database/'); // Update base path as needed

    router.addRoute('', () => { 

      client
      .from('blog')
      .select('post_title, post_slug ')
      .order('created_at', { ascending: false })
      .then(({ data, error }) => {
        if (error) {
          console.error('Error fetching characters:', error);
        } else {
          //console.log('Characters:', data);

          if(data.length > 0){

            $('#app').html('');
            $.each(data, function (i1, v1) { 

              var s1 = `
                <div class="card">
                  <div class="card-body "> 
                    <button type="button" class="btn btn-link btn_single_post" post_slug="${v1.post_slug}"> ${v1.post_title}</button>
                  </div>
                </div><br>
                `;
              $('#app').append(s1);
            });
          }
        }
      }); 
      
    });  
    
    
    router.addRoute('create', () => {
      
      var s1 = `
      <div class="container container-section top_container" id="sectionAddNew">
        <div class="row mt-4">
          <div class="col-md-12">
            <h3>Add a New Post</h3>
           
              <div class="form-group p-2">
                <input type="text" class="form-control" id="title" placeholder="Post Title" required>
              </div>

              <div class="form-group p-2">
                <input type="text" class="form-control" id="slug" placeholder="Post Slug" required>
              </div>
              <div class="form-group p-2">
                <textarea class="form-control" id="content" rows="4" placeholder="Post Content" required></textarea>
              </div>
              <button type="submit" class="btn btn-primary btn_save">Publish</button>
         
          </div>
        </div>
      </div>
      `;

      //remove all old instances
			tinymce.remove();

      $('#app').html(s1);
			app_editor('#content');      
    });  
 
    $(document).on('click', '.btn_save', async function (e) {
      e.preventDefault();

      const txt = tinyMCE.get('content').getContent();
      const title = $('#title').val();
      const slug = $('#slug').val();

      const post = {
        post_title: title,
        post_slug: slug,
        post_content: txt
      };

      //console.log('Attempting to insert post:', post);

      try {
        const { data, error } = await client
          .from('blog')
          .insert([post])
          .select(); // optional, used if you want the inserted rows returned

        if (error) {
          console.error('Insert failed:', error);
          alert('Insert failed: ' + error.message);
        } else {
          console.log('Insert successful:', data);
          //alert('Post saved successfully!');
        }
      } catch (err) {
        console.error('Unexpected error:', err);
        alert('Unexpected error occurred');
      }
    });
    


    router.addRoute('post/:id', (params) => {

      var post_slug = params.id;
      client
      .from('blog')
      .select('post_title, post_slug, post_content') 
      .eq('post_slug', post_slug)
      .then(({ data, error }) => {
        if (error) {
          console.error('Error fetching characters:', error);
        } else {
          
          //console.log('Characters:', data);

          if(data.length > 0){
        

            var s1 = `
            <div class="card">
              <div class="card-header">${data[0].post_title}</div>
              <div class="card-body">${data[0].post_content}</div>     
            </div><br><br>
            `;
              $('#app').html(s1);
           
          }
        }
      });

    });
  

    router.setDefault((path) => {      
      $('#app').html(`<h2>404 Not Found</h2><p>No route for: ${path}</p>`);
    });

    router.start();


    function app_editor (id )
		{
			var ele = !id ? 'div.tinymce' : id;
			tinymce.init(
			{
				selector: ele,
				height: 400,
				browser_spellcheck: true,
				valid_elements : '+*[*]',
				format: 'html',
				relative_urls: true,
				branding: false,
				//contextmenu: 'image',
				contextmenu: false,
				plugins: 
				[
					'advlist autolink lists link image charmap hr anchor pagebreak',
					'searchreplace wordcount visualblocks visualchars code fullscreen',
					'insertdatetime media nonbreaking save table directionality',
					'emoticons template paste textpattern codesample preview autoresize'
				],
				toolbar1:'undo redo |styleselect  | fontselect | fontsizeselect ',
				toolbar2: 'bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link unlink | image | emoticons',
				toolbar3: 'media | forecolor | backcolor  | fullscreen  preview | codesample code ',	
				fontsize_formats: "8px 10px 12px 14px 16px 18px 20px 22px 24px 46px",				
				image_advtab: true,
				rel_list: 
				[
					{title: 'nofollow', value: 'nofollow'},
					{title: 'follow', value: 'follow'}			
				], 		
			});
		}; 


    // Navigation handlers
    $('#nav-posts').click(e => {
      e.preventDefault();
      router.navigate('');
    });

    $('#nav-create').click(e => {
      e.preventDefault();
      router.navigate('create');
    });

    
    $(document).on('click', '.btn_single_post', async function (e) { 
      e.preventDefault();
      var post_slug = $(this).attr('post_slug');
      router.navigate('post/'+post_slug);
    });
 

  });