 $(document).ready(function () {
    
    const router = new Router('/run-framework/02-dynamic/'); // Update base path as needed

    router.addRoute('', () => {
      $('#app').html('<h2>Home Page</h2><p>Welcome to the home page!</p>');
    });   

    router.addRoute('user/:id', (params) => {
      $('#app').html(`<h2>User Page</h2><p>User ID: ${params.id}</p>`);
    });

    router.addRoute('search', (params) => {

      //q=router&type=advanced&page=2
      var s1 = `
        <p>Query: ${params.q}</p>
        <p>Type:  ${params.type}</p>
        <p>Page:  ${params.page}</p>
        
      `;

      var s2 = params.q ?  s1 : 'None';
      
      $('#app').html(`<h2>Search</h2>`+s2);


    });

    router.addRoute('ajax', (params) => {    
        
      var url = 'https://dummyjson.com/users';
      $.ajax({
        type: "GET",
        url: url,
        dataType: "json",
        success: function (data) {
          const jsonString = JSON.stringify(data, null, 2);
          $('#app').html(`<h2>Ajax</h2><pre class="text-bg-dark p-3 "> ${jsonString}</pre>`);
        }
      });
    });

    

    router.setDefault((path) => {      
      $('#app').html(`<h2>404 Not Found</h2><p>No route for: ${path}</p>`);
    });

    router.start();

    // Navigation handlers
    $('#nav-home').click(e => {
      e.preventDefault();
      router.navigate('');
    });

    

    $('#nav-user42').click(e => {
      e.preventDefault();
      router.navigate('user/42');
    });

    $('#nav-search').click(e => {
      e.preventDefault();
      router.navigate('search?q=router&type=advanced&page=2');
    });

    $('#nav-ajax').click(e => {
      e.preventDefault();
      router.navigate('ajax');
    });

  });