<?php 

function app_get_ip()
{
    // check for shared internet/ISP IP
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && app_validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }

    // check for IPs passing through proxies
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // check if multiple ips exist in var
        if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
            $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            foreach ($iplist as $ip) {
                if (app_validate_ip($ip))
                    return $ip;
            }
        } else {
            if (app_validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
                return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED']) && app_validate_ip($_SERVER['HTTP_X_FORWARDED']))
        return $_SERVER['HTTP_X_FORWARDED'];
    if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && app_validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
        return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && app_validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
        return $_SERVER['HTTP_FORWARDED_FOR'];
    if (!empty($_SERVER['HTTP_FORWARDED']) && app_validate_ip($_SERVER['HTTP_FORWARDED']))
        return $_SERVER['HTTP_FORWARDED'];

    // return unreliable ip since all else failed
    return $_SERVER['REMOTE_ADDR'];

}

function getClientIP($ip = null) {
    header('Content-Type: application/json');
    $url = 'https://ipwho.is/';
    if ($ip) {
        $url .= urlencode($ip);
    }
    $response = file_get_contents($url);
    $data = json_decode($response, true);
    // Function to exclude a key from the array
    function excludeKey($array, $excludeKey) {
        if (array_key_exists($excludeKey, $array)) {
            unset($array[$excludeKey]);
        }
        return $array;
    }
    $filtered = excludeKey($data, "flag");
    echo json_encode($filtered);
}



$router->map('GET', '/', function () {
    // Get client IP from REMOTE_ADDR if not provided
    echo "Hello World ";
    
    $clientIP = $_GET['ip'] ?? $_SERVER['REMOTE_ADDR'] ?? null;
    //getClientIP(app_get_ip());
});


$router->map('GET', '/[*:ip]/', function ($ip) {
    // If $ip is empty, fallback to REMOTE_ADDR
    $clientIP = $ip ?: app_get_ip() ?? null;
    getClientIP(app_get_ip());
});

$router->map('GET', '/ip/[*:ip]', function ($ip) {
    // If $ip is empty, fallback to REMOTE_ADDR
    $clientIP = $ip ?: ($_SERVER['REMOTE_ADDR'] ?? null);
    getClientIP($ip);
});


?>