<?php

//--->get app url > start

if (isset($_SERVER['HTTPS']) &&
    ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1) ||
    isset($_SERVER['HTTP_X_FORWARDED_PROTO']) &&
    $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https') {
  $ssl = 'https';
}
else {
  $ssl = 'http';
}
 
$app_url = ($ssl  )
          . "://".$_SERVER['HTTP_HOST']
          //. $_SERVER["SERVER_NAME"]
          . (dirname($_SERVER["SCRIPT_NAME"]) == DIRECTORY_SEPARATOR ? "" : "/")
          . trim(str_replace("\\", "/", dirname($_SERVER["SCRIPT_NAME"])), "/");

//--->get app url > end


//app url
define("APPURL", $app_url);

//absolute path to root directory of app
define("ABSPATH", str_replace("\\", "/",  dirname(__FILE__) ) );



//app folder
define("ABSPATH_App_Folder", ABSPATH.'/app');

//local folder > routes
define("ABSPATH_Routes_Folder", ABSPATH_App_Folder.'/routes');

//local folder > views
define("ABSPATH_Folder_View", ABSPATH_App_Folder.'/views');


//view folder url > admin
define("APPURL_View_Folder_Admin", $app_url.'/app/views/admin');

//view folder url > client
define("APPURL_View_Folder_Client", $app_url.'/app/views/client');


//ajax url > admin
define("APPURL_Ajax_Admin", $app_url.'/ajax/admin');



//allow external all api access
header("Access-Control-Allow-Origin: *");

//--->settings
include_once ABSPATH_App_Folder. '/_inc/_settings.php'; 



$router = new AltoRouter();
$base_path = trim(str_replace("\\", "/", dirname($_SERVER["SCRIPT_NAME"])), "/");
$router->setBasePath($base_path ? "/".$base_path : "");


//--->rountes
include_once ABSPATH_Routes_Folder. '/routes.php';


// match current request url
$match = $router->match();
 
// call closure or throw 404 status
if( $match && is_callable( $match['target'] ) ) 
{   
    
  //call_user_func_array( $match['target'], array_values($match['params'] )); 
  if (version_compare(PHP_VERSION, '7.4.2') > 0) 
  {
    //using php version 8 and higher
    call_user_func_array( $match['target'], array_values($match['params'] ));
  }
  else if (version_compare(PHP_VERSION, '8.0') < 0) 
  {
    //using php version 7 and lower
    call_user_func_array( $match['target'], $match['params'] ); 
  }
} 
else 
{
 
  // no route was matched
 
  //ob_start("app_minify_html");
  //ob_start("app_minify_js");
  
  echo "404 Page";
  header( $_SERVER["SERVER_PROTOCOL"] . ' 404 Not Found');
  echo "<br>";

  echo APPURL. $_SERVER['REQUEST_URI']; 

}


?>