<!DOCTYPE html>
<html>

<head>

	<title> <?php echo $doc_name ?> </title>

	<meta name="viewport" content="width=device-width, initial-scale=1">

	<meta name="description" content="<?php echo $doc_name ?> documentation">



	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js"></script>

	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/css/all.min.css" />

	<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.0/js/all.min.js"></script>


	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.1/css/bootstrap.min.css" />

	<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.2.1/js/bootstrap.bundle.min.js"></script>

	<script type="text/javascript">
		var doc_items = <?php echo json_encode($q1) ?>;

		var include_once = function(FileURL, cb)
		{
			var get_file_type = FileURL.split('.').pop().toLowerCase();

			//--->do js > start
			if(get_file_type == 'js')
			{
				var get_links    = document.getElementsByTagName('script');

				//--->loop through all the links > start
				var arr = [];
				for (var i = 0; i < get_links.length; i++) 
				{
					var v1 =  get_links[i]; 
					var link = v1.src;

					if(link == FileURL)
					{   
						arr.push(FileURL);
					}
				} 
				//--->loop through all the links > end

				//--->add to header > start
				if(arr.length < 1)
				{
					var head = document.getElementsByTagName('head')[0];
					var script = document.createElement('script');
					script.src = FileURL;
					script.type = 'text/javascript';
					script.setAttribute('async','true');
					head.appendChild(script);
					
					script.onerror = function() 
					{
						// Error loading https://example.com/404.js
						console.error("Error loading > " + this.src); 
					};
					if (cb) { script.onload = cb; };             
				}
				//--->add to header > end
			}

			//--->do js > end


			//--->do css > start
			if(get_file_type == 'css')
			{
				var get_links    = document.getElementsByTagName('link');

				//--->loop through all the links > start
				var arr = [];
				for (var i = 0; i < get_links.length; i++) 
				{
					var v1 =  get_links[i]; 
					var link = v1.href;

					if(link == FileURL)
					{       
						arr.push(FileURL);
					}
				} 
				//--->loop through all the links > end

				//--->add to header > start
				if(arr.length < 1)
				{
					var head = document.getElementsByTagName('head')[0];
					var script = document.createElement('link');
					script.href = FileURL;
					script.rel = 'stylesheet';
					script.setAttribute('async','true');
					head.appendChild(script);

					if (cb) { script.onload = cb; };
				}
				//--->add to header > end
			}
			//--->do css > end
		};

		var remove_once = function(FileURL)
		{
			var get_file_type = FileURL.split('.').pop().toLowerCase();

			//--->do js > start
			if(get_file_type == 'js')
			{
				var get_links    = document.getElementsByTagName('script');

				//--->loop through all the links > start
				var arr = [];
				for (var i = 0; i < get_links.length; i++) 
				{
					var v1 =  get_links[i]; 
					var link = v1.src;

					if(link == FileURL)
					{   
						arr.push(FileURL);
						v1.parentNode.removeChild(v1);
					}
				} 
				//--->loop through all the links > end        
			}
			//--->do js > end


			//--->do css > start
			if(get_file_type == 'css')
			{
				var get_links    = document.getElementsByTagName('link');

				//--->loop through all the links > start
				var arr = [];
				for (var i = 0; i < get_links.length; i++) 
				{
					var v1 =  get_links[i];
					var link = v1.href;

					if(link == FileURL)
					{       
						arr.push(FileURL);
						v1.parentNode.removeChild(v1);
					}
				} 
				//--->loop through all the links > end 
			}
			//--->do css > end
		};
		
		$(document).ready(function($) {

			var prism_css = "https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/themes/prism.min.css";
			var prism_js = "https://cdnjs.cloudflare.com/ajax/libs/prism/1.29.0/prism.min.js";
			

			var hash = document.URL.substr(document.URL.indexOf('#')+1) 
			var url = window.location.hash;
			var hash = $(location).prop('hash');

			

			function create_item_list(a0){
				var a1 = a0;

				var c1 = $(document).find('.item_select');
				//item_select
				$.each(a1,function(i1,v1){
					var s1 = '<div class="p-2">'
								+'<span class="btn btn-light border border-primary btn_item_select" item_id="'+v1.item_id+'">'+v1.item_name+'</span>'
							+'</div>';
					c1.append(s1);					
				});
			};

			function load_item_hash(){

				//will get the item url
				var item_slug =   window.location.hash.slice(1); 

				var item_id = '';
				var get_txt;
				$.each(doc_items, function(i1, v1) {					
					 
					if (v1.item_slug == item_slug) {
						get_txt = v1.item_txt;
						item_id = v1.item_id;
					}
				});
				$(document).find('.container_item_text').html(get_txt);

				//update item menu
				$(document).find('.btn_item_select').removeClass('btn-success');

				$('.btn_item_select').each(function(i1, v1) {					
					
					if ($(this).attr('item_id') == item_id) {						
						$(this).removeClass('btn-light')
						$(this).addClass('btn-success');
					}
				});

				include_once(prism_css);
		    	include_once(prism_js);
			};

			



			create_item_list(doc_items);

			load_item_hash();

			 

			//search items > start
			$(".searh_item").on("keyup", function() {
				var value = $(this).val().toLowerCase();
				$(".item_select *").filter(function() {
					$(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
				});
			});
			//--->search items > end

			 

			//--->selected a single item > start
			$(document).on('click', '.btn_item_select', function(event) {
				event.preventDefault();

				$(document).find('.btn_item_select').removeClass('btn-success');

				$(this).removeClass('btn-light')
				$(this).addClass('btn-success');

				var item_id = $(this).attr('item_id');
				var get_txt;
				$.each(doc_items, function(i1, v1) {					
					 
					if (v1.item_id == item_id) {

						window.location.hash = v1.item_slug;
						get_txt = v1.item_txt;
					}
				});
				$(document).find('.container_item_text').html(get_txt);

				///for code colorization				 
			
				remove_once(prism_css);
		    	remove_once(prism_js);

				include_once(prism_css);
		    	include_once(prism_js);
			});			
			//--->selected a single item > end

		

		});
	</script>

</head>

<body>



	<!-- Responsive navbar-->
	<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
		<div class="container">
			<a class="navbar-brand" href="#"><?php echo $doc_name ?></a>
			<button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation"><span class="navbar-toggler-icon"></span></button>

		</div>
	</nav>

	<!-- Page content-->
	<div class="p-2">
		<div class="row">

			<!--[item menu > start]-->
			<div class="col-md-3" style="overflow-y: auto;height: 400px;">

				<div class="item_search_box">
					<input class="form-control searh_item" id="myInput" type="text" placeholder="Search item.." style="width: 250px!Important;">
				</div>

				<div class="item_select">

					 

				</div>

			</div>
			<!--[item menu > end]-->

			<!--[item description > start]-->
			<div class="col-md-9 container_item_text p-5">


			</div>
			<!--[item description > end]-->

			

		</div>
	</div>

</body>

</html>