<?php


$router->map( 'GET', "/app/admin", function() {

    $app_name = "Code Doc";
    
    $page_title ="Code Doc > Admin Dashboard";
    $page_description ="This will help you create a documentation for your project";
    $author_name = "Code With Mark";
    $author_url = "https://codewithmark.com";
    
    $ajax_url = APPURL_Ajax_Admin;

    require ABSPATH_Folder_View. '/admin/view-admin-01a-home.php';
});



$router->map( 'GET', "/ajax/admin/doc-item", function() {

    //request type
    $ele = $_GET;

    //connect to database
    $db = app_db(); 


    $call_type 	=  $db->CleanDBData($ele['call_type']);   
    
    if($call_type == "all"){

        $q0 = $db->select("select * from  doc "); 
        $result =  array(
            'status' =>"success" , 
            'docs' => $q0, 
            'app_url'   => APPURL,
        );

    }else if($call_type == "single"){
        
        $doc_id 	=  $db->CleanDBData($ele['doc_id']); 
        
        $q0 = $db->select("select * from  doc where doc_id='$doc_id'"); 
        $q1 = $db->select("select * from  items where doc_id='$doc_id'"); 
        

        $result =  array(
            'status' =>"success" ,              
            'msg' => 'doc items',  
            "doc" =>$q0,
            "items"=> $q1,
        );
    }

    app_echo_json($result);
});


$router->map( 'POST', "/ajax/admin/doc-item", function() {

    //request type
    $ele = $_POST;

    //connect to database
    $db = app_db(); 

    
    $update_type 	=  $db->CleanDBData($ele['update_type']);    
    $doc_id 		=  $db->CleanDBData($ele['doc_id']);
    $doc_name 		=  $db->CleanDBData($ele['doc_name']);
    $doc_url 	    =  $db->CleanDBData($ele['doc_url_slug']);
    
    $doc_new_url = APPURL .'/'.$doc_url ;

    $doc_url_link = '<a class="btn btn-link" target="_blank" href="'.$doc_new_url.'">'.$doc_name.' </a>';

    if($update_type == "new"){

        //add new doc items

        //check if doc url is taken
        $q0 = $db->select("select * from  doc where doc_url='$doc_url' "); 

        if($q0 >0){ 
            //url is taken
            $result =  array(
                'status' =>"error" , 
                'code' => 'url_taken',
                'msg' => 'Doc url is taken...Please try another one',   
            );
        }else if($q0 <1){
            //url is avaliable
            $db->Insert('doc', array
            (
                'doc_id' 		    => $doc_id,
                'doc_name' 		    => $doc_name,
                'doc_url' 		    => $doc_url,
            ));

            //delete all items from the table
            $db->Delete("items",array('doc_id' => $doc_id )); 

            // Loop through items 
            foreach ($ele['items'] as $k1 => $v1) 
            { 
                $db->Insert('items', array
                (
                    'doc_id' 		    => $db->CleanDBData($v1['doc_id']),
                    'item_id' 		    => $db->CleanDBData($v1['item_id']),
                    'item_order_num'    => $db->CleanDBData($v1['item_order_num']),
                    'item_name'         => $db->CleanDBData($v1['item_name']),
                    'item_slug'         => $db->CleanDBData($v1['item_slug']),
                    'item_txt'         => $db->CleanDBData($v1['item_text']),

                ));                 
            }
            
            $result =  array(
                'status' =>"success" , 
                'code' => 'new',
                'msg' => 'Successfully added your doc. <br> '.$doc_url_link,   

                
            );
        }

    }else if($update_type == "edit"){

        //check if doc url is taken
        $q0 = $db->select("select * from  doc where doc_url='$doc_url' and doc_id<>'$doc_id'"); 
        if($q0 >0){ 
            //url is taken
            $result =  array(
                'status' =>"error" , 
                'code' => 'url_taken',
                'msg' => 'Doc url is taken...Please try another one',   
            );
        }else if($q0 <1){

            $array_fields = array(
                'doc_name' => $doc_name,
                'doc_url' => $doc_url,
            );
            $array_where = array('doc_id' => $doc_id);

            $db->Update('doc', $array_fields, $array_where);
            //delete all items from the table
            $db->Delete("items",array('doc_id' => $doc_id )); 

            // Loop through items 
            /* */
            foreach ($ele['items'] as $v1) 
            { 
                $db->Insert('items', array
                (
                    'doc_id' 		    => $db->CleanDBData($v1['doc_id']),
                    'item_id' 		    => $db->CleanDBData($v1['item_id']),
                    'item_order_num'    => $db->CleanDBData($v1['item_order_num']),
                    'item_name'         => $db->CleanDBData($v1['item_name']),
                    'item_slug'         => $db->CleanDBData($v1['item_slug']),
                    'item_txt'        => $db->CleanDBData($v1['item_text']),
                    //'item_txt'          => $v1['item_text'],

                ));                 
            }
            $result =  array(
                'status' =>"success" , 
                'code' => 'edit',
                'msg' => 'Successfully updated your doc . <br> '.$doc_url_link,   
            );
        }
    }
    app_echo_json($result);
});


$router->map( 'POST', "/ajax/admin/doc-item/delete", function() {

    //request type
    $ele = $_POST;

    //connect to database
    $db = app_db(); 


    $id 	=  $db->CleanDBData($ele['id']);   

    $q0 = $db->select("select * from  doc where doc_id='$id' "); 
    
    if($q0 < 1){

        $result =  array(
            'status' =>"error" ,              
            'msg'   => "Did not find your doc to be deleted ",
        );

    }else if($q0 > 0){
        
        $db->Delete("doc",array('doc_id' => $id )); 
        $db->Delete("items",array('doc_id' => $id )); 
         
        $result =  array(
            'status' =>"success",             
            'msg' => "Deleted your doc",   
        );
    }

    app_echo_json($result);
});

?>