<?php

/*
    Usefull php functions to help you code faster

*/
 
 
function GetTimeStamp($format_type='')
{
    $time_stamp_iso = date('c');
    $time_stamp_unix = date('U');

    $time_stamp = date('Y-m-d H:i:s');
    $date = date('Y-m-d');

    if($format_type == "iso")
    {
        return $time_stamp_iso;
    }
    elseif($format_type == "unix")
    {
        return $time_stamp_unix;
    }
    elseif($format_type == "dttm")
    {
        return $time_stamp;
    }
    elseif($format_type == "dt")
    {
        return $date;
    }
    else
    {
        return $time_stamp;
    }
}

function download($url) 
{
    set_time_limit(0);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    //curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    
    $r = curl_exec($ch);
    curl_close($ch);
    header('Expires: 0'); // no cache
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
    header('Cache-Control: private', false);
    header('Content-Type: application/force-download');
    header('Content-Disposition: attachment; filename="' . basename($url) . '"');
    header('Content-Transfer-Encoding: binary');
    header('Content-Length: ' . strlen($r)); // provide file size
    header('Connection: close');
    echo $r;
}

function crawlerDetect($USER_AGENT)
{
    $crawlers = array(
    'Google' => 'Google',
    'MSN' => 'msnbot',
    'Rambler' => 'Rambler',
    'Yahoo' => 'Yahoo',
    'AbachoBOT' => 'AbachoBOT',
    'accoona' => 'Accoona',
    'AcoiRobot' => 'AcoiRobot',
    'ASPSeek' => 'ASPSeek',
    'CrocCrawler' => 'CrocCrawler',
    'Dumbot' => 'Dumbot',
    'FAST-WebCrawler' => 'FAST-WebCrawler',
    'GeonaBot' => 'GeonaBot',
    'Gigabot' => 'Gigabot',
    'Lycos spider' => 'Lycos',
    'MSRBOT' => 'MSRBOT',
    'Altavista robot' => 'Scooter',
    'AltaVista robot' => 'Altavista',
    'ID-Search Bot' => 'IDBot',
    'eStyle Bot' => 'eStyle',
    'Scrubby robot' => 'Scrubby',
    'Facebook' => 'facebookexternalhit',
    'python-requests/2.8.1' => 'python-requests/2.8.1'
    );
    // to get crawlers string used in function uncomment it
    // it is better to save it in string than use implode every time
    // global $crawlers
    $crawlers_agents = implode('|',$crawlers);
    if (strpos($crawlers_agents, $USER_AGENT) === false)
    {
        return false;  
    }    
    else 
    {
        return TRUE;
    }
}


//--->Cookie - Start
function Cookie($method='get',$cookie_name = '', $cookie_value = '', $time_length ='')
{
    //= time() + (86400 * 7)
    $GetMethod = strtolower($method);

    if(!$time_length)
    {
        $time_length =time() + (86400 * 1); // 86400 = 1 day
    }


    //Add a cookie
    if($GetMethod =='set')
    {
        setcookie($cookie_name, $cookie_value, $time_length, "/"); 
        return true;
    }

    //Get a cookie
    if($GetMethod =='get')
    {
        return $_COOKIE[$cookie_name];
    }

    //Delete a cookie
    if($GetMethod =='delete')
    {
        
        // set the expiration date to one hour ago       
        setcookie($cookie_name, "", time() - 3600, "/");
        return true;
    }
}
//--->Cookie - End

//--->Session - Start
function Session($method='get',$session_name = '', $session_value = '' )
{
    // Start the session
    session_start();
    //session_start(); 
    ob_start(); 


    $GetMethod = strtolower($method);

    //Add a session
    if($GetMethod =='set')
    {
       $_SESSION[$session_name] = $session_value;
       return true;
    }

    //Get a session
    if($GetMethod =='get')
    {
        if($_SESSION[$session_name])
        {
            return  $_SESSION[$session_name];
        }
        else
        {
            return false; 
        }
       
    }

    //Delete a session
    if($GetMethod =='delete')
    {
        // remove all session variables
        session_unset(); 

        // destroy the session 
        session_destroy(); 
        return true;
    }
}
//--->Session - End


//--->IP Address - Start
function GetIP()
{
    // check for shared internet/ISP IP
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && validate_ip($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }

    // check for IPs passing through proxies
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // check if multiple ips exist in var
        if (strpos($_SERVER['HTTP_X_FORWARDED_FOR'], ',') !== false) {
            $iplist = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
            foreach ($iplist as $ip) {
                if (validate_ip($ip))
                    return $ip;
            }
        } else {
            if (validate_ip($_SERVER['HTTP_X_FORWARDED_FOR']))
                return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
    }
    if (!empty($_SERVER['HTTP_X_FORWARDED']) && validate_ip($_SERVER['HTTP_X_FORWARDED']))
        return $_SERVER['HTTP_X_FORWARDED'];
    if (!empty($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']) && validate_ip($_SERVER['HTTP_X_CLUSTER_CLIENT_IP']))
        return $_SERVER['HTTP_X_CLUSTER_CLIENT_IP'];
    if (!empty($_SERVER['HTTP_FORWARDED_FOR']) && validate_ip($_SERVER['HTTP_FORWARDED_FOR']))
        return $_SERVER['HTTP_FORWARDED_FOR'];
    if (!empty($_SERVER['HTTP_FORWARDED']) && validate_ip($_SERVER['HTTP_FORWARDED']))
        return $_SERVER['HTTP_FORWARDED'];

    // return unreliable ip since all else failed
    return $_SERVER['REMOTE_ADDR'];

}

/**
 * Ensures an ip address is both a valid IP and does not fall within
 * a private network range.
 */
function validate_ip($ip) 
{
    if (strtolower($ip) === 'unknown')
        return false;

    // generate ipv4 network address
    $ip = ip2long($ip);

    // if the ip is set and not equivalent to 255.255.255.255
    if ($ip !== false && $ip !== -1) {
        // make sure to get unsigned long representation of ip
        // due to discrepancies between 32 and 64 bit OSes and
        // signed numbers (ints default to signed in PHP)
        $ip = sprintf('%u', $ip);
        // do private network range checking
        if ($ip >= 0 && $ip <= 50331647) return false;
        if ($ip >= 167772160 && $ip <= 184549375) return false;
        if ($ip >= 2130706432 && $ip <= 2147483647) return false;
        if ($ip >= 2851995648 && $ip <= 2852061183) return false;
        if ($ip >= 2886729728 && $ip <= 2887778303) return false;
        if ($ip >= 3221225984 && $ip <= 3221226239) return false;
        if ($ip >= 3232235520 && $ip <= 3232301055) return false;
        if ($ip >= 4294967040) return false;
    }
    return true;
}

//--->IP Address - End

//--->Get Referer URL - Start
function GetRefURL()
{
    $GetRefURL = isset($_SERVER['HTTP_REFERER']);   
    if($GetRefURL)
    {
        $URL = GetDomainName($_SERVER["HTTP_REFERER"]);
    }
    else if(!$GetRefURL)
    {
        $URL = 'Direct'; 
    }
    return $URL; 
}
//--->Get Referer URL - End



//--->Get Domain Name - Start
function GetDomainName($url)
{
    $host = @parse_url($url, PHP_URL_HOST);
    // If the URL can't be parsed, use the original URL
    // Change to "return false" if you don't want that
    if (!$host)
        $host = $url;
    // The "www." prefix isn't really needed if you're just using
    // this to display the domain to the user
    if (substr($host, 0, 4) == "www.")
        $host = substr($host, 4);
    // You might also want to limit the length if screen space is limited
    if (strlen($host) > 50)
        $host = substr($host, 0, 47) . '...';
    return $host;
}
//--->Get Domain Name - End

//--->Remove HTTP - Star
function RemoveHTTP($url) 
{
   $disallowed = array('http://', 'https://');
   foreach($disallowed as $d) 
   {
      if(strpos($url, $d) === 0) 
      {
         return str_replace($d, '', $url);
      }
   }
   return $url;
}
//--->Remove HTTP - End

//--->URL Redirect - Start
function URLRedirect($URL)
{
    ob_start();
    // End automatic output buffering
    ob_end_clean(); 

    Header( "HTTP/1.1 301 Moved Permanently" );  
     
    //Redirect to dashbord
    header('Location: ' . $URL);
    exit(); 

}
//--->URL Redirect - End


//--->Auto Hash - Start   
function AutoHash($has_name = 'crc32') 
{
    /*
        Use this to create auto/random code

        More hash options - http://codewithmark.com/?p=291
    */
    
    $alphanum = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    $special  = '~!@#$%^&*(){}[],./?';
    $alphabet = $alphanum . $special;

    //This WILL make sure the auto code is random!!!
    $String = $alphabet.mt_rand().microtime().uniqid();
    
    //if $_hash_name is "crc32", it wil return 8 characters long auto code        
    return hash($has_name,$String);       
}
//--->Auto Hash - End


//--->Hash Password - Start 
function HashPassword($Password)
{
    /*
        Use this to hash user password.

        More hash options - http://codewithmark.com/?p=291
    */
 
    $Code = hash('sha512', $Password);  
    return $Code;
}
//--->Hash Password - End


//--->Create API Key - Start
function APIKey($String)
{
    /*
        Use this to create api keys

        More hash options - http://codewithmark.com/?p=291
    */
 
    $Code = hash('sha1', $String);  
    return $Code;
}
//--->Create API Key - End



function CURL_Call($call_method = 'GET', $api_url, $post_data_array = array() )
{
    
    /*
        $call_method ='POST';
        $api_url = 'http://yoursite.com/api/v1/create';

        $post_data_array = array(
            'format' => 'json',
            'apikey' => '1245679798'
        ); 

        //Make the call : CURL_Call($call_method, $api_url, $post_data_array = array() )
    */
    
    $post_data = json_encode($post_data_array);

    $curl = curl_init($api_url); 
    
    curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $call_method); 

    curl_setopt($curl, CURLOPT_URL, $api_url);
    
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    
    curl_setopt($curl, CURLOPT_POST, 1);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $post_data);
    
    $result = curl_exec($curl);

    curl_close($curl);
    
    //For error checking
    if ( $result === false )
    {
        echo 'error:' . curl_error($curl);
    }

    return $result;
 
}